REBOL [
    title: "ImmobilierNet Module agence - Menu principal"
    version: 1.0
    author: "Olivier Auverlot"
]

menu-principal: make object! [

    options: [ "Fiches clients" "Affaires" "Nomenclatures" ]
    num-table: 1  


    charge-table: function [ nt ] [] [
        ; si nomenclature -> on ne peut Ajouter ou effacer
        either nt <> 3 [
            show ajbtn
            show supbtn
        ] [
            hide ajbtn
            hide supbtn
        ]
        
        donnees: copy []
        donnee/user-data: copy []
        
        num: none
        num-table: nt
        switch num-table [
            1 [
                if (envoi-sql "SELECT num,nom,prenom FROM clients ORDER BY nom") [
                    foreach ligne buffer [ 
                        append donnees join trim ligne/2 [ " " (trim ligne/3)]                        
                        append donnee/user-data ligne/1
                    ]
                ]
            ]
            2 [
                if (envoi-sql "SELECT num,adr1,ville FROM affaires ORDER BY ville,adr1") [
                    foreach ligne buffer [ 
                        append donnees join trim ligne/2 [ " - " (trim ligne/3)]
                        append donnee/user-data ligne/1
                    ]              
                ]
            ]
            3 [
                donnees: copy [ 
                    "Types de Chauffage" 
                    "Etats des affaires" 
                    "Types des murs" 
                    "Styles des affaires" 
                    "Localisations gographiques"
                    "Types de toiture" 
                ]
                donnee/user-data: copy [ 1 2 3 4 5 6 ]
            ]
        ]
        clear donnee/data
        append donnee/lines donnees
        fix-slider donnee
        show donnee
    ]
    
    menu: layout [
        backtile 192.192.192
        title "ImmobilierNet - Menu principal"
        option: choice 200  data options [
            charge-table (where options option/text)
        ]
        donnee: text-list 300 data [] [ 
            ; rcupration de la cl primaire
            num: pick donnee/user-data face/cnt
        ]
        across
        button "Editer" [           
            if num <> none [
                do pick [
                    [ clients/start num ]
                    [ affaires/start num ]
                    [ nomenclatures/start num]
                ] (index? option/data)        
            ]
        ]
        ajbtn: button "Ajouter" [
            do pick [
                [ clients/start none ]
                [ affaires/start none ]
            ] (index? option/data)
        ]
        supbtn: button "Supprimer" [
            if num <> none [
                switch num-table [
                    1 [ nom-table: copy "clients" ]
                    2 [ nom-table: copy "affaires"]
                ]
                envoi-sql join "DELETE FROM " [
                    nom-table " WHERE num=" num
                ]
                charge-table num-table
            ]
        ]
        do [ 
            charge-table 1 
        ]
    ]

    start: does [ view menu ]
]